package rozwiazania_zadan.r4.z6_slowa;

import static java.util.stream.Collectors.*;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Scanner;
import java.util.function.Function;
import java.util.regex.Pattern;

// Sortowanie wg ilości.
// Wersja z zapisem strumieniowym.
// Tutaj jednak używam Scannera, który dzieli wejście na słowa bez pośredniego podziału na linie,
// a słowa odczytuję za pomocą tokens().

// W tej wersji wyniki od razu wypisuję, bez zbierania do końcowej mapy.
// (Przy czym mapa jest tworzona na początku za pomocą collect)

public class PoliczWszystkieSlowa6b {

	public static void main(String[] args) {
		final Pattern pattern = Pattern.compile("[^\\p{L}\\d]+");
		
		// Aby uzyskać komparator, który porównuje po pierwsze wartości, a po drugie klucze,
		// i to prawidłowo alfabetycznie, musiałem tak kombinować... ale wyszło
		final Comparator<Entry<String, Long>> komparator1 =
				Comparator.comparing(Map.Entry::getValue);
		final Comparator<Entry<String, Long>> komparator2 =
				komparator1.thenComparing(Map.Entry::getKey, Collator.getInstance());
		
		try(Scanner sc = new Scanner(new File("pan-tadeusz.txt"))) {
			sc.useDelimiter(pattern);
			sc.tokens()
				.map(String::toLowerCase)
				.collect(groupingBy(Function.identity(), counting()))
				.entrySet()
				.stream()
				.sorted(komparator2)
				.map(entry -> String.format("%-15s -> %4d", entry.getKey(), entry.getValue()))
				.forEachOrdered(System.out::println)
			;
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
