package rozwiazania_zadan.r4.z6_slowa;

import static java.util.stream.Collectors.*;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import java.util.regex.Pattern;

// Sortowanie wg ilości.
// Wersja z zapisem strumieniowym.
// Tutaj jednak używam Scannera, który dzieli wejście na słowa bez pośredniego podziału na linie,
// a słowa odczytuję za pomocą tokens().

// Na końcu staram się uzyskać mapę z zebranymi wynikami, ale mapę typu LinkedHashMap, któa zachowuje kolejność,
// dzięki czemu mam mapę "posortowaną wg wartości".

public class PoliczWszystkieSlowa6a {

	public static void main(String[] args) {
		final Pattern pattern = Pattern.compile("[^\\p{L}\\d]+");
		
		try(Scanner sc = new Scanner(new File("pan-tadeusz.txt"))) {
			sc.useDelimiter(pattern);
			Map<String, Long> slownik = sc.tokens()
				.map(String::toLowerCase)
				.collect(groupingBy(Function.identity(), counting()))
				.entrySet()
				.stream()
				.sorted(Map.Entry.comparingByValue())
				.collect(toMap(Map.Entry::getKey, Map.Entry::getValue, Long::sum, LinkedHashMap::new))
			;
				
			System.out.printf("Mam wyniki. Słownik zawiera %d unikalnych słów.\n", slownik.size());
			
			slownik.forEach((slowo, ilosc) -> {
				System.out.printf("%-15s -> %4d\n", slowo, ilosc);
			});
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
