package rozwiazania_zadan.r4.z6_slowa;

import static java.util.stream.Collectors.*;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import java.util.regex.Pattern;

// Sortowanie alfabetyczne.
// Wersja z zapisem strumieniowym (tokens).
// Tutaj w inny sposób sortuję wyniki - nie na etapie budowania słownika, ale później już jako listę...
// W sumie to wersja gorsza od pozostałych.

public class PoliczWszystkieSlowa5d {

	public static void main(String[] args) {
		final Pattern pattern = Pattern.compile("[^\\p{L}\\d]+");
		
		try(Scanner sc = new Scanner(new File("pan-tadeusz.txt"))) {
			sc.useDelimiter(pattern);
			sc.tokens()
				.collect(groupingBy(Function.identity(), counting()))
				.entrySet()
				.stream()
				.sorted(Map.Entry.comparingByKey())
				.map(entry -> String.format("%-15s -> %4d", entry.getKey(), entry.getValue()))
				.forEachOrdered(System.out::println)
			;
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
