package rozwiazania_zadan.r4.z6_slowa;

import static java.util.stream.Collectors.*;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Pattern;

// Sortowanie alfabetyczne.
// Wersja z zapisem strumieniowym (tokens).
// W tej wersji w inny sposób buduję mapę.

public class PoliczWszystkieSlowa5c {

	public static void main(String[] args) {
		final Pattern pattern = Pattern.compile("[^\\p{L}\\d]+");
		
		try(Scanner sc = new Scanner(new File("pan-tadeusz.txt"))) {
			sc.useDelimiter(pattern);
			Map<String, Integer> slownik = sc.tokens()
				.collect(toMap(s->s, s->1, Integer::sum, TreeMap::new));
			
			slownik.forEach((slowo, ilosc) -> {
					System.out.printf("%-15s -> %4d\n", slowo, ilosc);
				});
			;
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
