package rozwiazania_zadan.r4.z6_slowa;

import static java.util.stream.Collectors.*;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;

// Sortowanie alfabetyczne.
// Wersja z zapisem strumieniowym (tokens).
// W tej wersji nie normalizuję wielkości liter, nie stosuję Collator (dzięki temu działa szybciej) i od razu, w jednym wywołaniu, wypisuję wyniki.

public class PoliczWszystkieSlowa5b {

	public static void main(String[] args) {
		final Pattern pattern = Pattern.compile("[^\\p{L}\\d]+");
		
		try(Scanner sc = new Scanner(new File("pan-tadeusz.txt"))) {
			sc.useDelimiter(pattern);
			sc.tokens()
				.collect(groupingBy(Function.identity(), TreeMap::new, counting()))
				.forEach((slowo, ilosc) -> {
					System.out.printf("%-15s -> %4d\n", slowo, ilosc);
				});
			;
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
