package rozwiazania_zadan.r4.z6_slowa;

import static java.util.stream.Collectors.*;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;

// Sortowanie alfabetyczne.
// Wersja z zapisem strumieniowym.
// Tutaj jednak używam Scannera, który dzieli wejście na słowa bez pośredniego podziału na linie,
// a słowa odczytuję za pomocą tokens().

// W tej wersji wyniki zbieram do mapy, którą wykorzystuję w następnym kroku.

public class PoliczWszystkieSlowa5a {

	public static void main(String[] args) {
		final Pattern pattern = Pattern.compile("[^\\p{L}\\d]+");
		
		System.out.println("Start...");
		try(Scanner sc = new Scanner(new File("pan-tadeusz.txt"))) {
			sc.useDelimiter(pattern);
			SortedMap<String, Long> slownik = sc.tokens()
				.map(String::toLowerCase)
				.collect(groupingBy(Function.identity(), () -> new TreeMap<>(Collator.getInstance()), counting()))
			;
			
			System.out.printf("Mam wyniki. Słownik zawiera %d unikalnych słów.\n", slownik.size());
			
			slownik.forEach((slowo, ilosc) -> {
				System.out.printf("%-15s -> %4d\n", slowo, ilosc);
			});
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
