package rozwiazania_zadan.r4.z6_slowa;

import static java.util.stream.Collectors.*;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

// Wersja z zapisem strumieniowym.
// Tutaj plik dzielę na linie, następnie na słowa, ale potem łączę to w jeden strimień.
// To jest przykład zastosowania dość zawiłej w działaniu operacji "flatMap".
// To jest mniej wydajne niż wersja 5, ale też pokazuję taką wersję.

// W tej wersji łączę wszystko w jeden łancuch wywołań i dodatkowo zamieniam słowa na małe litery.
// groupingBy i counting są zaimportowane z Collections.
public class PoliczWszystkieSlowa4b {

	public static void main(String[] args) {
		try {
			Files.lines(Paths.get("pan-tadeusz.txt"))
				.flatMap(linia -> Stream.of(linia.split("[^\\p{L}\\d]+")))
				.filter(Predicate.not(String::isEmpty))
				.map(String::toLowerCase)
				.collect(groupingBy(Function.identity(), counting()))
				.entrySet().stream()
				.sorted(Map.Entry.comparingByValue())
				.forEachOrdered(entry -> System.out.printf("%-15s -> %4d\n", entry.getKey(), entry.getValue()));
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
