package rozwiazania_zadan.r4.z6_slowa;


import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

// Wersja z zapisem strumieniowym.
// Tutaj plik dzielę na linie, następnie na słowa, ale potem łączę to w jeden strimień.
// To jest przykład zastosowania dość zawiłej w działaniu operacji "flatMap".
// To jest mniej wydajne niż wersja 5, ale też pokazuję taką wersję.

// W tej wersji wyniki liczenia zapisuję w (nieposortowanej) mapie. Rozróżniam także wielkość liter.
public class PoliczWszystkieSlowa4a {

	public static void main(String[] args) {
		try {
			Map<String, Long> slownik = Files.lines(Paths.get("pan-tadeusz.txt"))
				.flatMap(linia -> Arrays.stream(linia.split("[^\\p{L}\\d]+")))
				.filter(Predicate.not(String::isEmpty))
				.collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
			
			slownik.entrySet().stream()
				.sorted(Map.Entry.comparingByValue())
				.forEachOrdered(entry -> System.out.printf("%-15s -> %4d\n", entry.getKey(), entry.getValue()));
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
