package rozwiazania_zadan.r4.z6_slowa;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

// W tej wersji sortuję słowa wg ilości wystąpień.
// W tej wersji używam Collator (co spowalnia) i rozróżniam wielkość liter.
// Drobna różnica jest też w sort.
public class PoliczWszystkieSlowa3b {

	public static void main(String[] args) {
		File plik = new File("pan-tadeusz.txt");
		Map<String, Integer> slownik = zbieranieDanych(plik);
		wypisanieDanych(slownik);
	}

	private static Map<String, Integer> zbieranieDanych(File plik) {
		System.out.println("Zbieranie danych...");
		Map<String, Integer> slownik = new TreeMap<>(Collator.getInstance());
		try(Scanner sc = new Scanner(plik)) {
			sc.useDelimiter("[^\\p{L}\\d]+");
			
			while(sc.hasNext()) {
				String slowo = sc.next().toLowerCase();
				int ileBylo = slownik.getOrDefault(slowo, 0);
				slownik.put(slowo, ileBylo + 1);
			}

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return slownik;
	}

	private static void wypisanieDanych(Map<String, Integer> slownik) {
		System.out.println("Sortowanie...");
		List<Map.Entry<String, Integer>> lista =
				new ArrayList<>(slownik.entrySet());
		
		lista.sort(Map.Entry.comparingByValue());
		
		System.out.println("Wypisywanie:");
		for(Map.Entry<String, Integer> entry : lista) {
			System.out.printf("%-15s -> %4d\n", entry.getKey(), entry.getValue());
		}
		System.out.println("Różnych słów: " + slownik.size());
	}
}
