package rozwiazania_zadan.r4.z6_slowa;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

// W tej wersji sortuję słowa wg ilości wystąpień. Rozróżniam wielkość liter.
public class PoliczWszystkieSlowa3a {

	public static void main(String[] args) {
		File plik = new File("pan-tadeusz.txt");
		
		System.out.println("Startujemy...");
		
		Map<String, Integer> slownik = zbieranieDanych(plik);
		wypisanieDanych(slownik);
	}

	private static Map<String, Integer> zbieranieDanych(File plik) {
		Map<String, Integer> slownik = new LinkedHashMap<>();
		
		try(Scanner sc = new Scanner(plik)) {
			sc.useDelimiter("[^\\p{L}\\d]+");
			
			while(sc.hasNext()) {
				String slowo = sc.next();
				int ileBylo = slownik.getOrDefault(slowo, 0);
				slownik.put(slowo, ileBylo + 1);
			}

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return slownik;
	}

	private static void wypisanieDanych(Map<String, Integer> slownik) {
		// Aby posortować: tworzę listę na podstawie mapy, lista zawiera wpisy (Entry).
		List<Map.Entry<String, Integer>> lista =
				new ArrayList<>(slownik.entrySet());
		
		// Listę można posortować
		lista.sort((e1, e2) -> e1.getValue() - e2.getValue());
		
		// Tu przeglądam elementy listy, a nie mapy!
		for(Map.Entry<String, Integer> entry : lista) {
			System.out.printf("%-15s -> %4d\n", entry.getKey(), entry.getValue());
		}
		System.out.println("Różnych słów: " + slownik.size());
	}
}
