package rozwiazania_zadan.r4.z6_slowa;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.Collator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

// W tej wersji takie zmiany:
//  * zamieniam słowa na małe litery
//  * używam TreeMap aby posortować alfabetycznie
//  * użycie Collator - czyli sortowania zgodnego z alfabetem - mocno spowalnia (wypróbuj różne wersje)
//  * używam getOrDefault
public class PoliczWszystkieSlowa2 {

	public static void main(String[] args) {
		File plik = new File("pan-tadeusz.txt");
		System.out.println("Startujemy...");
		Map<String, Integer> slownik = zbieranieDanych(plik);
		System.out.println();
		wypisanieDanych(slownik);
	}

	private static Map<String, Integer> zbieranieDanych(File plik) {
// różne wersje słowników do spróbowania...
		// HashMap nie utrzymuje żadnej sensownej kolejności
		// Map<String, Integer> slownik = new HashMap<>();
		
		// LinkedHashMap utrzybuje kolejnosc taka, w jakiej elementy byly dodawane po raz pierwszy
		// Map<String, Integer> slownik = new LinkedHashMap<>();
		
		// TreeMap sortuje wpisy wg kluczy; dla String-a domyslne sortowanie w oparciu o kody Unicode
		// Map<String, Integer> slownik = new TreeMap<>();
		
		// Collator daje sortowanie Stringow wg alfabetu
		Map<String, Integer> slownik = new TreeMap<>(Collator.getInstance());
		
		try(Scanner sc = new Scanner(plik)) {
			sc.useDelimiter("[^\\p{L}\\d]+");
			
			while(sc.hasNext()) {
				String slowo = sc.next().toLowerCase();
				int ileBylo = slownik.getOrDefault(slowo, 0);
				slownik.put(slowo, ileBylo + 1);
			}

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return slownik;
	}

	private static void wypisanieDanych(Map<String, Integer> slownik) {
		for(Map.Entry<String, Integer> entry : slownik.entrySet()) {
			System.out.printf("%-15s -> %4d\n", entry.getKey(), entry.getValue());
		}
		System.out.println("Różnych słów: " + slownik.size());
	}
}
