package rozwiazania_zadan.r4.z6_slowa;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

// Wersja z zastosowanym standardowym schematem "grupowania", już w pełni poprawnym, ale bez żadnych bajerów ani nowości.
public class PoliczWszystkieSlowa1 {

	public static void main(String[] args) {
		File plik = new File("pan-tadeusz.txt");
		
		Map<String, Integer> slownik = zbieranieDanych(plik);
		wypisanieDanych(slownik);
	}

	private static Map<String, Integer> zbieranieDanych(File plik) {
		Map<String, Integer> slownik = new HashMap<>();
		
		try(Scanner sc = new Scanner(plik)) {
			sc.useDelimiter("[^\\p{L}\\d]+");
			
			while(sc.hasNext()) {
				String slowo = sc.next();
				if(slownik.containsKey(slowo)) {
					// slowo juz wystepowalo, musimy odczytac dotychcasowa wartosc i dodac jeden
					int ileBylo = slownik.get(slowo);
					slownik.put(slowo, ileBylo + 1);
				} else {
					// widzimy slowo po raz pierwszy
					slownik.put(slowo, 1);
				}
			}

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return slownik;
	}

	private static void wypisanieDanych(Map<String, Integer> slownik) {
		System.out.println("Zebrane dane:");
		for(Map.Entry<String, Integer> entry : slownik.entrySet()) {
			System.out.printf("%-15s -> %4d\n", entry.getKey(), entry.getValue());
		}
		System.out.println("Różnych słów: " + slownik.size());
	}
}
