package rozwiazania_zadan.r4.z5_slowa.inne_przyklady;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;

// Przeglądanie wszystkich słów: readAllLines i dzielenie split-em.
// Skoro i tak zużywam dużo pamięci, to także słowa zbieram tu sobie do listy i dopiero potem analizuję.
public class WypiszSlowa1 {

	public static void main(String[] args) {
		System.out.println("Zbieram słowa...");
		
		// Dla odmiany używam LinkedList zamiast ArrayList.
		List<String> wszystkieSlowa = new LinkedList<>();
		try {
			List<String> linie = Files.readAllLines(Paths.get("pan-tadeusz.txt"));
			for(String linia : linie) {
				String[] slowa = linia.split("[^\\p{L}\\d]+");
				for(String slowo : slowa) {
					if(!slowo.isEmpty()) {
						wszystkieSlowa.add(slowo);
					}
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		System.out.println();
		for (String slowo : wszystkieSlowa) {
			System.out.println("[" + slowo + "]");
		}
		
		System.out.println("Ilość wszystkich słów: " + wszystkieSlowa.size());
	}

}
