package rozwiazania_zadan.r4.z5_slowa;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PoliczJednoSlowoInteraktywnie {

	public static void main(String[] args) {
		JFileChooser chooser = new JFileChooser(".");
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setFileFilter(new FileNameExtensionFilter("Pliki tekstowe", "txt", "ini", "csv", "md"));
		chooser.setDialogTitle("Wybierz plik");
		int coSieStalo = chooser.showOpenDialog(null);
		if(coSieStalo != JFileChooser.APPROVE_OPTION)
			return;
		File plik = chooser.getSelectedFile();
		String szukane = JOptionPane.showInputDialog("Jakie słowo mam policzyć?");
		if(szukane == null)
			return;
		int ile = policzSlowo(plik, szukane);
		JOptionPane.showMessageDialog(null,
				"Szukane słowo " + szukane + " występuje " + ile + " razy.");
	}

	private static int policzSlowo(File plik, String szukane) {
		int ile = 0;
		try(Scanner sc = new Scanner(plik)) {
			sc.useDelimiter("[^\\p{L}]+");
			
			while(sc.hasNext()) {
				String slowo = sc.next();				
				if(szukane.equals(slowo)) {
					ile++;
				}
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return ile;
	}
}
