package rozwiazania_zadan.r4.z1_sklep.wersja_obiektowa;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

public class Sklep {
	private Map<String, ProductInfo> towary = new TreeMap<>();
	private File plik;
	
	public Sklep(File plik) {
		this.plik = plik;
	}

	void wczytajCennik() {
		towary.clear();
		List<ProductInfo> lista = ObslugaPliku.wczytajPlik(plik);
		for (ProductInfo product : lista) {
			towary.put(product.getTowar(), product);
		}
	}

	void zapiszCennik() {
		ObslugaPliku.zapiszPlik(plik, towary.values());
	}
	
	void wyswietlCennik() {
		System.out.println("Cennik:");
		for (ProductInfo towar : towary.values()) {
			System.out.println(towar);
		}
		System.out.println();
	}

	void ustawCene(String towar, BigDecimal cena) {
		ProductInfo rekord = towary.get(towar);
		if (rekord == null) {
			rekord = new ProductInfo(towar, cena, 0);
			towary.put(towar, rekord);
		} else {
			rekord.setCena(cena);
		}	
	}

	ProductInfo getProduct(String towar) {
		return towary.get(towar);
		
// FIXME brak produktu
//		if (!towary.containsKey(towar)) {
//		System.out.printf("Nie ma takiego towaru: %s\n", towar);
//		continue;
//		}

	}

	void dostawa(String towar, int ilosc) {
		ProductInfo rekord = towary.get(towar);
		rekord.zmienIlosc(ilosc);
		// nie trzeba robić put, bo to jest referencja do tego samego obiektu
		System.out.printf("Dodano %d sztuk towaru %s.\nObecnie w magazynie jest %d sztuk.\n",
				towar, ilosc, rekord.getIlosc());
	}
}
