package rozwiazania_zadan.r4.z1_sklep.wersja_obiektowa;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ObslugaPliku {
	private static final String SEPARATOR = ",";
	
	public static List<ProductInfo> wczytajPlik(File plik) {
		List<ProductInfo> lista = new ArrayList<>();
		try(Scanner skanerPliku = new Scanner(plik)) {
			while(skanerPliku.hasNextLine()) {
				String linia = skanerPliku.nextLine();
				String[] pola = linia.split(SEPARATOR);
				ProductInfo towar = new ProductInfo(pola[0], new BigDecimal(pola[1]), Integer.valueOf(pola[2]));
				lista.add(towar);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return lista;
	}

	public static void zapiszPlik(File plik,  Iterable<ProductInfo> lista) {
		try(PrintWriter out = new PrintWriter(plik)) {
		    for(ProductInfo towar : lista) {
		        out.printf("%s%s%.2f%s%d%n", towar.getTowar(), SEPARATOR, towar.getCena(), SEPARATOR, towar.getIlosc());
		    }

		} catch(IOException e) {
		    e.printStackTrace();
		}
	}

}
