package rozwiazania_zadan.r4.z1_sklep.wersja_obiektowa;

import java.io.File;
import java.math.BigDecimal;
import java.util.InputMismatchException;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

public class Aplikacja {
	private static final File PLIK_CENNIKA = new File("cennik2.txt");

	private Map<String, ProductInfo> towary;
	private Scanner scanner;
	private Sklep sklep;

	
	public static void main(String[] args) {
		Aplikacja obiekt = new Aplikacja();
		obiekt.dzialaj();
	}
	
	private Aplikacja() {
		Locale.setDefault(Locale.US);
		sklep = new Sklep(PLIK_CENNIKA);
		towary = new TreeMap<>();
		scanner = new Scanner(System.in);
	}

	private void dzialaj() {
		sklep.wczytajCennik();
		
		menuGlowne: while(true) {
            String wybor = menu();
            
            switch(wybor) {
            case "Q":
            	break menuGlowne;
            case "W":
            	sklep.wyswietlCennik();
        		break;
            case "Z":
				zakupy();
				break;
            case "D":
                dostawa();
                break;
            case "C":
                ustawCene();
                break;
            case "R":
            	sklep.wczytajCennik();
            	break;
            case "S":
                sklep.zapiszCennik();
                break;
            default:
            	System.out.println("Nieznana operacja");
            }
		}
	}

	private String menu() {
		System.out.println();
		System.out.println("Wybierz operację:");
		System.out.println(" Q - zakończ program");
		System.out.println(" W - wypisz cennik dostępnych towarów");
		System.out.println(" Z - zakupy");
		System.out.println(" D - dostawa");
		System.out.println(" C - ustal cenę");
		System.out.println(" R - wczytaj cennik ponownie z pliku");
		System.out.println(" S - zapisz cennik do pliku");
		String wybor = scanner.nextLine().trim().toUpperCase();
		return wybor;
	}
	
	private void ustawCene() {
		System.out.println("Podaj nazwę towaru:");
		String towar = scanner.nextLine();
		System.out.println("Podaj nową cenę:");
		BigDecimal cena = scanner.nextBigDecimal();
		scanner.nextLine();
		sklep.ustawCene(towar, cena);
	}

	private void zakupy() {
		BigDecimal suma = BigDecimal.ZERO;
		while(true) {
			System.out.printf("Podaj nazwę towaru (puste aby przerwać): ");
			String towar = scanner.nextLine();
			if(towar.isEmpty()) break;
			ProductInfo rekord = sklep.getProduct(towar);
			System.out.println(rekord);
			System.out.printf("Ile sztuk chcesz kupić? ");
			int ilosc = scanner.nextInt();
			scanner.nextLine();
			if(ilosc <= 0) {
				System.out.println("Ilość musi być dodatnia");
				continue;
			}
			BigDecimal koszt = BigDecimal.valueOf(ilosc).multiply(rekord.getCena());
			System.out.printf("Za %d sztuk towaru %s do zapłaty: %.2f zł\n", ilosc, towar, koszt);
			suma = suma.add(koszt);
		}
		System.out.printf("Łącznie za zakupy zapłacisz: %.2f zł\n", suma);
	}

	private void dostawa() {
		System.out.printf("Podaj nazwę towaru: ");
		String towar = scanner.nextLine();
		if (!towary.containsKey(towar)) {
			System.out.printf("Nie ma takiego towaru: %s\n", towar);
			return;
		}
		int ilosc = -1;
		while(true) try {
			System.out.printf("Ile sztuk dostarczyć? ");
			ilosc = scanner.nextInt();
			scanner.nextLine();
			if(ilosc > 0)
				break;
			System.out.println("Ilość musi być dodatnia");
		} catch (InputMismatchException e) {
			System.out.println("Niepoprawny format liczby");
		}
		sklep.dostawa(towar, ilosc);
	}
}


