package rozwiazania_zadan.r4.z1_sklep;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.InputMismatchException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;

public class Sklep9 {
	private static final File PLIK_CENNIKA = new File("cennik2.txt");
	private static final String SEPARATOR = ",";

	private Map<String, Double> cennik;
	private Map<String, Integer> magazyn;
	private Scanner scanner;

	
	public static void main(String[] args) {
		Sklep9 obiekt = new Sklep9();
		obiekt.dzialaj();
	}
	
	private Sklep9() {
		Locale.setDefault(Locale.US);
		cennik = new LinkedHashMap<>();
		magazyn = new LinkedHashMap<>();
		scanner = new Scanner(System.in);
	}

	private void dzialaj() {
		wczytajCennik();
		
		menuGlowne: while(true) {
            String wybor = menu();
            
            switch(wybor) {
            case "Q":
            	break menuGlowne;
            case "W":
            	wyswietlCennik();
        		break;
            case "Z":
				zakupy();
				break;
            case "D":
                dostawa();
                break;
            case "C":
                ustawCene();
                break;
            case "R":
            	wczytajCennik();
            	break;
            case "S":
                zapiszCennik();
                break;
            default:
            	System.out.println("Nieznana operacja");
            }
		}
	}

	private String menu() {
		System.out.println();
		System.out.println("Wybierz operację:");
		System.out.println(" Q - zakończ program");
		System.out.println(" W - wypisz cennik dostępnych towarów");
		System.out.println(" Z - zakupy");
		System.out.println(" D - dostawa");
		System.out.println(" C - ustal cenę");
		System.out.println(" R - wczytaj cennik ponownie z pliku");
		System.out.println(" S - zapisz cennik do pliku");
		String wybor = scanner.nextLine().trim().toUpperCase();
		return wybor;
	}

	private void wyswietlCennik() {
		System.out.println("Cennik:");
		for (Map.Entry<String, Double> entry : cennik.entrySet()) {
			System.out.printf(" * %-16s - %8.2f zł\n", entry.getKey(), entry.getValue());
		}
		System.out.println();
	}

	private void wczytajCennik() {
		cennik.clear();
		magazyn.clear();
		try(Scanner skanerPliku = new Scanner(PLIK_CENNIKA)) {
			while(skanerPliku.hasNextLine()) {
				String linia = skanerPliku.nextLine();
				String[] pola = linia.split(SEPARATOR);
				cennik.put(pola[0], Double.valueOf(pola[1]));
				magazyn.put(pola[0], Integer.valueOf(pola[2]));
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}

	private void zapiszCennik() {
		try(PrintWriter out = new PrintWriter(PLIK_CENNIKA)) {
		    for(String towar : cennik.keySet()) {
		    	double cena = cennik.get(towar);
		    	int ilosc = magazyn.get(towar);
		        out.printf("%s%s%.2f%s%d%n", towar, SEPARATOR, cena, SEPARATOR, ilosc);
		    }

		} catch(IOException e) {
		    e.printStackTrace();
		}
	}

	private void ustawCene() {
		System.out.println("Podaj nazwę towaru:");
		String towar = scanner.nextLine();
		System.out.println("Podaj nową cenę:");
		double cena = scanner.nextDouble();
		scanner.nextLine();
		cennik.put(towar, cena);
	}

	private void zakupy() {
		double suma = 0;
		while(true) {
			System.out.printf("Podaj nazwę towaru (puste aby przerwać): ");
			String towar = scanner.nextLine();
			if(towar.isEmpty()) break;
			if (!cennik.containsKey(towar)) {
				System.out.printf("Nie ma takiego towaru: %s\n", towar);
				continue;
			}
			double cena = cennik.get(towar);
			System.out.printf("Cena jednostkowa towaru %s: %.2f zł\nIle sztuk chcesz kupić? ", towar, cena);
			int ilosc = scanner.nextInt();
			scanner.nextLine();
			if(ilosc <= 0) {
				System.out.println("Ilość musi być dodatnia");
				continue;
			}
			double koszt = ilosc * cena;
			System.out.printf("Za %d sztuk towaru %s do zapłaty: %.2f zł\n", ilosc, towar, koszt);
			suma += koszt;
		}
		System.out.printf("Łącznie za zakupy zapłacisz: %.2f zł\n", suma);
	}

	private void dostawa() {
		System.out.printf("Podaj nazwę towaru: ");
		String towar = scanner.nextLine();
		if (!magazyn.containsKey(towar)) {
			System.out.printf("Nie ma takiego towaru: %s\n", towar);
			return;
		}
		int ilosc = -1;
		while(true) try {
			System.out.printf("Ile sztuk dostarczyć? ");
			ilosc = scanner.nextInt();
			scanner.nextLine();
			if(ilosc > 0)
				break;
			System.out.println("Ilość musi być dodatnia");
		} catch (InputMismatchException e) {
			System.out.println("Niepoprawny format liczby");
		}
		final int ustalonaIlosc = ilosc;
		int nowaIlosc = magazyn.computeIfPresent(towar, (k, v) -> v+ustalonaIlosc);
		System.out.printf("Dodano %d sztuk towaru %s.\nObecnie w magazynie jest %d sztuk.\n", towar, ilosc, nowaIlosc);
	}

}
