package rozwiazania_zadan.r2.z1.p4_pierwsze;

import java.util.Scanner;

public class LiczbyPierwsze3 {
	// W tej wersji korzystam z tego, że jeśli liczba ma dzielnik (inny niż 1 i ona sama), to ten dzielnik
	// musi być <= pierwiastka z tej liczby. Wystarczy więc iść w pętli do pierwiastka.
	// Porównaj czas działania np. dla 2147483647 z wersją 2.
	
	static boolean czyPierwsza(long liczba) {
		if(liczba == 1) {
			return false;
		}
		
		for(long i = 2; i <= Math.sqrt(liczba+1); i++) {
			// wpisałem liczba+1, aby zmniejszyć ryzyko problemów z dokładnością doubli (dla dużych liczb)
			// jednocześnie jest to poprawne dla początkowych liczb, bo sqrt(3) < 2
			if(liczba % i == 0) {
				return false;
			}
		}
		return true;
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		System.out.println("Aby zakończyć, wpisz 0");
		while(true) {
			System.out.print("Podaj liczbę: ");
			long liczba = sc.nextLong();
			if(liczba == 0) break;
			
			// pomiar czasu
			long p = System.currentTimeMillis();
			boolean wynik = czyPierwsza(liczba);
			long k = System.currentTimeMillis();
			
			if(wynik) {
				System.out.println("Liczba " + liczba + " jest pierwsza");
			} else {
				System.out.println("Liczba " + liczba + " nie jest pierwsza");
			}
			System.out.println("Sprawdzenie trwało " + (k-p) + " ms");
			System.out.println();
		}

	}

}
