package przyklady.pan_tadeusz.imperatywnie;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

public class PoliczSlowa3 {

	public static void main(String[] args) {
		System.out.println("Startujemy");
		
		Map<String, Integer> slowa = new TreeMap<>();

		File plik = new File("pan-tadeusz.txt");
		try(Scanner sc = new Scanner(plik)) {
			sc.useLocale(Locale.US);
			sc.useDelimiter("[^\\p{L}\\d]+");
			
			while(sc.hasNext()) {
				String slowo = sc.next();
				int ileBylo = slowa.getOrDefault(slowo, 0);
				slowa.put(slowo, ileBylo + 1);
			}
			
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		
		List<Map.Entry<String, Integer>> lista = new ArrayList<>(slowa.entrySet());
		lista.sort(Map.Entry.comparingByValue());
		
		for (Map.Entry<String, Integer> entry : lista) {
			System.out.printf("%30s -> %5d\n", entry.getKey(), entry.getValue());
		}
	}

}
