package przyklady.pan_tadeusz.imperatywnie;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

public class PoliczSlowa2 {

	public static void main(String[] args) {
		System.out.println("Startujemy");
		
		Map<String, Integer> slowa = new TreeMap<>(Collator.getInstance());

		File plik = new File("pan-tadeusz.txt");
		try(Scanner sc = new Scanner(plik)) {
			sc.useLocale(Locale.US);
			sc.useDelimiter("[^\\p{L}\\d]+");
			
			
			while(sc.hasNext()) {
				String slowo = sc.next();
				int ileBylo = slowa.getOrDefault(slowo, 0);
				slowa.put(slowo, ileBylo + 1);
			}
			
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		slowa.forEach((slowo, ilosc) -> {
			System.out.printf("%30s -> %5d\n", slowo, ilosc);
		});
	}

}
