package przyklady.pan_tadeusz.funkcyjnie;

import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PanTadeusz_PoliczSlowa5 {

	public static void main(String[] args) {
		
		try {
			Files.lines(Paths.get("pan-tadeusz.txt"), Charset.forName("utf-8"))
				.flatMap(line -> Stream.of(line.split("[^\\p{L}^\\d]+")))
				.filter(s -> !s.trim().isEmpty())
				.map(String::toLowerCase)
				.collect(Collectors.groupingBy(
						Function.identity(),
						TreeMap::new,
						Collectors.counting()))
				.entrySet()
				.stream()
				.sorted(Entry.comparingByValue())
				.forEach(entry -> System.out.printf("%20s -> %5d\n", entry.getKey(), entry.getValue()));
		
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
