package przyklady.emps.obiektowo;

import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;

import przyklady.emps.Employee;
import przyklady.emps.ObslugaCSV;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;

public class P3a_SredniaWybranych {
    public static void main(String[] args) {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setFileFilter(new FileNameExtensionFilter("Pliki CSV", "csv"));
        chooser.setDialogTitle("Wybierz plik");
        int coSieStalo = chooser.showOpenDialog(null);
        if(coSieStalo == JFileChooser.APPROVE_OPTION) {
            File wybranyPlik = chooser.getSelectedFile();
            List<Employee> employees = ObslugaCSV.wczytaj(wybranyPlik);

            String kogoSzukam = JOptionPane.showInputDialog("Podaj nazwę stanowiska");
            if(kogoSzukam != null) {
            	double srednia = sredniaJob(employees, kogoSzukam);
            	JOptionPane.showMessageDialog(null, "Średnia: " + srednia);
            }
        }
    }

	private static double sredniaJob(List<Employee> employees, String kogoSzukam) {
		double suma = 0;
		int ilosc = 0;
		for (Employee emp : employees) {
		    if(Objects.equals(emp.getJobTitle(), kogoSzukam)) {
		        suma += emp.getSalary();
		        ilosc++;
		    }
		}
		return suma / ilosc;
	}
}
