package przyklady.emps.funkcyjnie;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import przyklady.emps.Employee;
import przyklady.emps.ObslugaCSV;

public class Partycje {

	public static void main(String[] args) {
		List<Employee> lista = ObslugaCSV.wczytaj("employees.csv");
		
		Map<Boolean, List<Employee>> partycje1 = lista.stream()
				.collect(Collectors.partitioningBy(emp -> emp.getSalary() >= 10000));
			
		System.out.println("Bogaci:");
		partycje1.get(true)
			.forEach(emp -> System.out.println("  " + emp.getLastName()));

		System.out.println("\nBiedni:");
		partycje1.get(false)
			.forEach(emp -> System.out.println("  "+ emp.getLastName()));
		System.out.println();
		
		Map<Boolean, Long> partycje2 = lista.stream()
				.collect(Collectors.partitioningBy(
						emp -> emp.getSalary() >= 10000,
						Collectors.counting()));
		
		System.out.println("Bogatych " + partycje2.get(true));
		System.out.println("Biednych " + partycje2.get(false));
	}

}
