package przyklady.emps.funkcyjnie;

import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import przyklady.emps.Employee;
import przyklady.emps.ObslugaCSV;

public class F7_Grupowanie_v3 {

	public static void main(String[] args) {
		List<Employee> lista = ObslugaCSV.wczytaj("employees.csv");
		
		Map<String, IntSummaryStatistics> grupy = lista.stream()
				.collect(Collectors.groupingBy(Employee::getJobTitle,
						Collectors.summarizingInt(Employee::getSalary)));
		
		grupy.forEach((job, stats) -> {
			System.out.printf("| %-32s| %2d | %8.2f | %8d | %8d |\n",
					job, stats.getCount(), stats.getAverage(), stats.getMin(), stats.getMax());
		});
	}
}
