package przyklady.emps.funkcyjnie;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import przyklady.emps.Employee;
import przyklady.emps.ObslugaCSV;

public class F7_Grupowanie_v2 {

	public static void main(String[] args) {
		List<Employee> lista = ObslugaCSV.wczytaj("employees.csv");
		
		Map<String, Double> grupy = lista.stream()
				.collect(Collectors.groupingBy(Employee::getJobTitle,
						Collectors.averagingInt(Employee::getSalary)));
		
		grupy.forEach((job, srednia) -> {
			System.out.printf("| %-32s| %8.2f |\n", job, srednia);
		});
	}
}
