package przyklady.emps.funkcyjnie;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import przyklady.emps.Employee;
import przyklady.emps.ObslugaCSV;

public class F7_Grupowanie_v1 {

	public static void main(String[] args) {
		List<Employee> lista = ObslugaCSV.wczytaj("employees.csv");
		
		Map<String, List<Employee>> grupy = lista.stream().collect(Collectors.groupingBy(Employee::getJobTitle));
		
		grupy.forEach((job, grupa) -> {
			System.out.println("Pracownicy na stanowisku " + job + ":");
			grupa.forEach(emp -> {
				System.out.println("   * " + emp.getFirstName() + " " + emp.getLastName());
			});
			System.out.println();
		});
	}
}
