package przyklady.emps.funkcyjnie;

import java.util.List;
import java.util.Optional;

import przyklady.emps.Employee;
import przyklady.emps.ObslugaCSV;

public class F4c_MinMax {

	public static void main(String[] args) {
		List<Employee> lista = ObslugaCSV.wczytaj("employees.csv");
		
		// W tej wersji Comparator definiuję za pomocą wyrażeń lambda - ale to nie jest ładne jeśli da się użyć "comparing"...
		// Uwaga: odejmowanie int-ów w celu porównania może być niepoprawne z powodu overflow
		// ale tutaj jest poprawne, bo wszystkie wszystkoie pensje są dodatnie
		
		Optional<Employee> min = lista.stream()
				.min((emp1, emp2) -> emp1.getSalary() - emp2.getSalary());
				
		Optional<Employee> max = lista.stream()
				.max((emp1, emp2) -> emp1.getSalary() - emp2.getSalary());
		
		System.out.println("min: " + min);
		System.out.println("max: " + max);
		System.out.println();
		
		// Przykłady obsługi typu Optional:
		// prosty if
		if(min.isPresent()) {
			Employee emp = min.get();
			System.out.println(emp.getFirstName() + " " + emp.getLastName() + " zarabia " + emp.getSalary());
		} else {
			System.out.println("Brak danych");
		}
		if(max.isPresent()) {
			Employee emp = max.get();
			System.out.println(emp.getFirstName() + " " + emp.getLastName() + " zarabia " + emp.getSalary());
		} else {
			System.out.println("Brak danych");
		}
		
		// sprytny map
		String txt = max.map(emp ->
				"nazywa się " + emp.getFirstName() + " " +emp.getLastName()
				+ " i zarabia " + emp.getSalary())
			.orElse("nie istnieje");

			System.out.println("Najbogatszy " + txt);
	}
}
