package przyklady.emps.funkcyjnie;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;

import przyklady.emps.Employee;
import przyklady.emps.ObslugaCSV;

public class F4b_MinMax {

	public static void main(String[] args) {
		List<Employee> lista = ObslugaCSV.wczytaj("employees.csv");
		
		Optional<Employee> min = lista.stream()
				.min(Comparator.comparingInt(Employee::getSalary));
				
		Optional<Employee> max = lista.stream()
				.max(Comparator.comparingInt(Employee::getSalary));
		
		System.out.println("min: " + min);
		System.out.println("max: " + max);
		System.out.println();
		
		// Przykłady obsługi typu Optional:
		// prosty if
		if(min.isPresent()) {
			Employee emp = min.get();
			System.out.println(emp.getFirstName() + " " + emp.getLastName() + " zarabia " + emp.getSalary());
		} else {
			System.out.println("Brak danych");
		}
		if(max.isPresent()) {
			Employee emp = max.get();
			System.out.println(emp.getFirstName() + " " + emp.getLastName() + " zarabia " + emp.getSalary());
		} else {
			System.out.println("Brak danych");
		}
		
		// sprytny map
		String txt = max.map(emp ->
				"nazywa się " + emp.getFirstName() + " " +emp.getLastName()
				+ " i zarabia " + emp.getSalary())
			.orElse("nie istnieje");

			System.out.println("Najbogatszy " + txt);
	}
}
