package przyklady.emps.funkcyjnie;

import java.util.List;
import java.util.OptionalDouble;

import javax.swing.JOptionPane;

import przyklady.emps.Employee;
import przyklady.emps.ObslugaCSV;

public class F3a_SredniaWybranych_v3 {

	public static void main(String[] args) {
		
		String job = JOptionPane.showInputDialog("Podaj nazwę stanowiska:");
		if(job == null) {
			return;
		}
		
		List<Employee> lista = ObslugaCSV.wczytaj("employees.csv");
		
		OptionalDouble srednia = lista.stream()
			.filter(emp -> job.equalsIgnoreCase(emp.getJobTitle()))
			.mapToInt(Employee::getSalary)
			.average();
		
		if(srednia.isPresent()) {
			JOptionPane.showMessageDialog(null, "Średnia na stanowisku " + job + " wynosi " + srednia.getAsDouble());
		} else {
			JOptionPane.showMessageDialog(null, "Nie ma pracowników na stanowisku " + job, "Brak danych", JOptionPane.WARNING_MESSAGE);
		}
	}

}
