package przyklady.emps.funkcyjnie;

import java.util.List;
import java.util.OptionalDouble;
import java.util.concurrent.ThreadLocalRandom;

import javax.swing.JOptionPane;

import przyklady.emps.Employee;
import przyklady.emps.ObslugaCSV;

public class F3a_SredniaWybranych_v2 {

	public static void main(String[] args) {
		
		String job = JOptionPane.showInputDialog("Podaj nazwę stanowiska:");
		if(job == null) {
			return;
		}
		
		List<Employee> lista = ObslugaCSV.wczytaj("employees.csv");
		
		OptionalDouble srednia = lista.stream()
			.filter(emp -> job.equalsIgnoreCase(emp.getJobTitle()))
			.mapToInt(Employee::getSalary)
			.average();
		
		// Jak można odczytać wynik OptionalDouble ?
		// 0) po prostu print
		System.out.println(srednia);
		
		// 1) sprawdzić metodami isPresent() albo isEmpty() czy wynik istnieje i pobrać za pomocą getAsDouble
		
		if(srednia.isPresent()) {
			System.out.println("JEST " + srednia.getAsDouble());
		} else {
			System.out.println("NIE MA");
		}
		
		// 2) zamienić na wartość domyślną
		double wynik = srednia.orElse(0.0);
		System.out.println("Średnia : " + wynik);
		
		// 3) jakieś rozwiązania "funkcyjne" ....
		// Tutaj: w razie braku danych wylosuj liczbę
		double wynik2 = srednia.orElseGet(() -> ThreadLocalRandom.current().nextDouble());
		System.out.println("Średnia2: " + wynik2);
	}

}
