package przyklady.emps.funkcyjnie;

import java.util.List;

import przyklady.emps.Employee;
import przyklady.emps.ObslugaCSV;

public class F2_SredniaWszystkich_v5 {

	public static void main(String[] args) {
		List<Employee> lista = ObslugaCSV.wczytaj("employees.csv");

		// To tylko prezentacja operacji reduce, czysta teoria.
		// Akurat wyliczenie średniej (/statystyk) lepiej robić tak jak w wersjach 1-4
		
		// Działanie reduce na tym przykładzie:
		// Zacznij od 0 i dla każdego elementu (tutaj każdej pensji) wykonaj podaną operację (tutaj: operację dodawania)
		int suma = lista.stream()
			.mapToInt(Employee::getSalary)
			.reduce(0, Integer::sum);

		double srednia = (double)suma / lista.size();
		System.out.println("Średnia: " + srednia);
	}

}
