package alx.p46_tcp;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;

public class Serwer1 {

	public static void main(String[] args) {
		try {
			System.out.println("tworzę socket");
			try(ServerSocket serverSocket = new ServerSocket(5555)) {

				System.out.println("czekam na połączenie");
				try(Socket connectionSocket = serverSocket.accept()) {
					System.out.println("jest klient: " + connectionSocket.getRemoteSocketAddress());
					
					// true oznacza "autoFlush"
					try(Scanner sc = new Scanner(connectionSocket.getInputStream());
						PrintWriter out = new PrintWriter(connectionSocket.getOutputStream(), true)) {
						
						System.out.println("Czytam tekst od klienta...");
						String tekst = sc.nextLine();
						System.out.println("Klient napisał: " + tekst);
						
						tekst = tekst.toUpperCase();
						System.out.println("wysyłam do klienta...");
						out.println(tekst);
						System.out.println("wysłane...");
					}
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
