package alx.p45_serializacja;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;

public class TestOdczytu {

	public static void main(String[] args) {
		System.out.println("Otwieram");
		try(FileInputStream fis = new FileInputStream("zapisane.ser");
			ObjectInputStream ois = new ObjectInputStream(fis)) {
			System.out.println("Czytam pierwszy obiekt...");
			Object o = ois.readObject();
			System.out.println("\nWczytałem "+o.getClass().getSimpleName() + " " + o.toString());

			if(o instanceof Osoba) {
				Osoba osoba1 = (Osoba) o;
				System.out.println();
				System.out.println("Gatunek to "+osoba1.gatunek);				
				Osoba partner = osoba1.getPartner();
				System.out.println("Partnerem osoby1 jest "+partner);
				
				System.out.println("Czytam drugi obiekt...");
				Osoba osoba2 = (Osoba) ois.readObject();
				System.out.println("Osoba 2 "+osoba2);
				System.out.println(partner == osoba2); // true
				
				int x = ois.readInt();
				System.out.println("int = "+x);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		
	}

}
