package alx.p43_files;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class WizytowanieMatcher {
	private static PathMatcher pm = FileSystems.getDefault().getPathMatcher("glob:**moje**.java");
	//private static PathMatcher pm = FileSystems.getDefault().getPathMatcher("regex:.*owa.*\\.java");

	public static void main(String[] args) {
		try {
			Path start = Paths.get("src");
			MojWizytorZMatcherem visitor = new MojWizytorZMatcherem();
			
			Files.walkFileTree(start, visitor);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}


private static class MojWizytorZMatcherem extends SimpleFileVisitor<Path> {

	@Override
	public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs)
			throws IOException {
		System.out.println("preVisitDirectory "+dir);
		
		if("p10_klasy".equals(dir.getFileName().toString())) {
			System.out.println("p10_klasy - omijam");
			return FileVisitResult.SKIP_SUBTREE;
		} else
			return FileVisitResult.CONTINUE;
	}

	@Override
	public FileVisitResult visitFile(Path file, BasicFileAttributes attrs)
			throws IOException {
		
		boolean pasuje = pm.matches(file);
		
		System.out.println("visitFile "+file + " " + pasuje);
		
		return FileVisitResult.CONTINUE;
	}

	@Override
	public FileVisitResult visitFileFailed(Path file, IOException exc)
			throws IOException {
		System.out.println("visitFileFailed "+file);
		return FileVisitResult.CONTINUE;
	}

	@Override
	public FileVisitResult postVisitDirectory(Path dir, IOException exc)
			throws IOException {
		System.out.println("postVisitDirectory "+dir);
		return FileVisitResult.CONTINUE;
	}
	
}

}