package alx.p43_files;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Sciezki {

	public static void main(String[] args) {
		
		//Path p = Paths.get("A/B/C");
		//Path p = Paths.get("B/C");
		Path p = Paths.get("/A/../B/C");
		System.out.println(p);

		System.out.println(p.isAbsolute());
		System.out.println(p.getNameCount());
		System.out.println(p.getFileName());
		System.out.println(p.getName(0));
		System.out.println(p.getName(1));
		//System.out.println(p.getName(2));

		FileSystem fs = p.getFileSystem();
		System.out.println(fs + " " + fs.isReadOnly());
		
		System.out.println(p.getRoot()); // null
		
		Path parent = p.getParent();
		System.out.println("parent: " + parent);
		
		Path norm = p.normalize();
		System.out.println("normalize: " + norm);

		Path inny = Paths.get("A/B/D");
		
		System.out.println("resolve " + p.resolve(inny));
		System.out.println(inny.toAbsolutePath());
		System.out.println(p.resolve(inny.toAbsolutePath()));
		System.out.println(p.resolve("/home/users"));
		System.out.println(p.toAbsolutePath().resolve("/home/users"));
		System.out.println("abs res " + p.toAbsolutePath().resolve(inny));

//		System.out.println("rel " + p.relativize(inny));
//		System.out.println(p.normalize());
//		System.out.println(p.normalize().relativize(inny));

		System.out.println("Poprawny relativize: /A/B/C relativize /A/X/Y :");		
		System.out.println(Paths.get("/A/B/C").relativize(Paths.get("/A/X/Y")));

		// to jest wyjatek, bo mieszam absolute i relative
		//System.out.println(Paths.get("A/B/C").relativize(Paths.get("A/X/Y")));

		//System.out.println(p.normalize().relativize(inny.toAbsolutePath()));
		//System.out.println(p.toAbsolutePath().relativize(inny));

		System.out.println(p.normalize().toAbsolutePath().relativize(inny.toAbsolutePath()));
		
	}

}

