package alx.p43_files;

import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Map;
import java.util.Set;

public class FilesProperties_Unix {

	public static void main(String[] args) {
		try {
			String name;
			if(args.length > 0)
				name = args[0];
			else name = "src";
			//else name = "link_do_katalogu";
			
		Path start = Paths.get(name);
		
		System.out.println("dir " + Files.isDirectory(start));
		System.out.println("dirL " + Files.isDirectory(start, LinkOption.NOFOLLOW_LINKS));
		System.out.println("exe " + Files.isExecutable(start));
		System.out.println("hid " + Files.isHidden(start));
		System.out.println("reg " + Files.isRegularFile(start));
		System.out.println("regL" + Files.isRegularFile(start, LinkOption.NOFOLLOW_LINKS));
		System.out.println("red " + Files.isReadable(start));
		System.out.println("wri " + Files.isWritable(start));
		System.out.println("sym " + Files.isSymbolicLink(start));
		System.out.println("lmt " + Files.getLastModifiedTime(start));
		System.out.println("lmtL" + Files.getLastModifiedTime(start, LinkOption.NOFOLLOW_LINKS));
		
		FileStore store = Files.getFileStore(start);
		System.out.println("store total " + store.getTotalSpace() + " (" + store.getTotalSpace() / 1_000_000 + "M)");
		System.out.println("store usable " + store.getUsableSpace() + " (" + store.getUsableSpace() / 1_000_000 + "M)");
		
		BasicFileAttributes attrs = Files.readAttributes(start, BasicFileAttributes.class);
		System.out.println("A reg " + attrs.isRegularFile());
		System.out.println("A time " + attrs.lastModifiedTime());
		System.out.println("A other " + attrs.isOther());

		DosFileAttributes dattrs = Files.readAttributes(start, DosFileAttributes.class);
		System.out.println("D reg " + dattrs.isRegularFile());
		System.out.println("D arc " + dattrs.isArchive());
		
		PosixFileAttributes pattrs = Files.readAttributes(start, PosixFileAttributes.class);
		System.out.println("P reg " + pattrs.isRegularFile());
		System.out.println("P own " + pattrs.owner());
		System.out.println("P grp " + pattrs.group());
		Set<PosixFilePermission> permissions = pattrs.permissions();
		System.out.println("POSIX permissions: " + permissions);
		
		Set<PosixFilePermission> permissions2 = Files.getPosixFilePermissions(start);
		System.out.println("POSIX perms again: "+permissions2);
		
		
		System.out.println("Lista atrybutów");
		Map<String, Object> pAttributes = Files.readAttributes(start, "*");
		for(Map.Entry<String, Object> entry : pAttributes.entrySet()) {
			System.out.println(entry.getKey() + " : "+entry.getValue());
		}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
