package alx.p36_lokalizacja;

import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;

public class HelloInternational {

	public static void main(String[] args) {
		Locale actualLocale;

		if (args.length == 2) {
			String language = args[0];
			String country = args[1];
			actualLocale = new Locale(language, country);
		} else {
			actualLocale = Locale.getDefault();
		}
		System.out.println("Używam locali "+actualLocale);
		
		ResourceBundle messages = ResourceBundle.getBundle("tlumaczenia.NaszBundle", actualLocale);
		System.out.println("Klasa bundla "+messages.getClass().getName());
		
		System.out.println(messages.getString("greetings"));
		System.out.println(messages.getObject("inquiry"));
		System.out.println(messages.getString("farewell"));

		Object obiekt = messages.getObject("liczba");
		// Object obiekt = messages.getString("liczba"); // wyjatek
		
		System.out.println("Klasa "+obiekt.getClass() + " " + obiekt);

		System.out.println(Arrays.toString(messages.getStringArray("tablica")));
	}
}
