package alx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Student {
    private String imie, nazwisko;
    private final List<Integer> oceny = new ArrayList<>();

    public Student() {
        this("", "");
    }

    public Student(String imie, String nazwisko) {
        this.imie = imie;
        this.nazwisko = nazwisko;
    }

    public Student(String imie, String nazwisko, Collection<Integer> oceny) {
        this.imie = imie;
        this.nazwisko = nazwisko;
        this.oceny.addAll(oceny);
    }

    public String getImie() {
        return imie;
    }

    public void setImie(String imie) {
        this.imie = imie;
    }

    public String getNazwisko() {
        return nazwisko;
    }

    public void setNazwisko(String nazwisko) {
        this.nazwisko = nazwisko;
    }

    public List<Integer> getOceny() {
        return Collections.unmodifiableList(oceny);
    }

    public void setOceny(List<Integer> oceny) {
        this.oceny.clear();
        this.oceny.addAll(oceny);
    }

    public void dodajOcene(int ocena) {
        this.oceny.add(ocena);
    }

    @Override
    public String toString() {
        return "Student{" +
                "imie='" + imie + '\'' +
                ", nazwisko='" + nazwisko + '\'' +
                ", oceny=" + oceny +
                '}';
    }
}

