package alx;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

@Path("/dt")
// @Produces("text/plain")
@Produces(MediaType.TEXT_PLAIN)
public class CzasSimple {

    @GET
    public LocalDateTime dateTime() {
        return LocalDateTime.now();
    }

    @Path("/date")
    @GET
    public LocalDate date() {
        return LocalDate.now();
    }

    @Path("/time")
    @GET
    public LocalTime time() {
        return LocalTime.now();
    }

    @Path("/time/sec")
    @GET
    public int getSecond() {
        return LocalTime.now().getSecond();
    }
}
