package alx;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

@Path("/dt0")
@Produces(MediaType.TEXT_PLAIN)
public class CzasField {
    private LocalDateTime dt = LocalDateTime.now();

    @GET
    public LocalDateTime dateTime() {
        return dt;
    }

    @Path("/date")
    @GET
    public LocalDate date() {
        return dt.toLocalDate();
    }

    @Path("/time")
    @GET
    public LocalTime time() {
        return dt.toLocalTime();
    }
}
