package beans;

import java.util.Random;

/* Klasa jest "Java Bean" jeśli:
 * 1) posiada publiczny konstruktor bezargumentowy (tzw. "default constructor")
 * 2) dostęp do własności ("properties") udostępniony poprzez gettery i settery (nie ma obowiązku aby zawsze była para)
 * ... wzorzec Java Bean opisuje też technikę powiadamiania o zdarzeniach (korzysta się z tego przede wszystkim w GUI), ale w większości przypadków wystarczają te dwie powyższe cechy
 */

// konstruktor domyślny jest tworzony automatycznie

public class PrzykladowyBean {
    private String napis = "Ala ma kota";
    private Random random = new Random();
    private int liczba;
    
    public String getNapis() {
        return napis;
    }
    
    public String getNapisDuzymiLiterami() {
        return napis.toUpperCase();
    }
    
    public void setNapis(String napis) {
        this.napis = napis;
    }
    
    public String[] getWords() {
        return napis.split(" ");
    }
    
    public int wylosuj() {
        return random.nextInt(1000);
    }

    @Override
    public String toString() {
        return "PrzykladowyBean z zawartością " + napis;
    }
}
