package przyklady;

import hr.model.Country;
import hr.model.Location;
import hr.model.Region;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;

public class P9_Merge {

    public static void main(String[] args) {
        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr");
            EntityManager em = emf.createEntityManager()) {
            em.getTransaction().begin();

            Location loc = new Location();
            loc.setId(3300);
            loc.setCountry(em.find(Country.class, "PL"));
            loc.setStreetAddress("Ciemna");
            loc.setCity("Kraków");
            loc.setPostalCode("99-999");
            System.out.println(loc);

            System.out.println("Ponowny find");
            Location lokalizacjaFind = em.find(Location.class, 3300);
            System.out.println(lokalizacjaFind);

            System.out.println("merge");
            // gdyby nie było id - zrobiłby inserta
            // jeśli jest id - to robi updejta
            Location lokalizacjaMerge = em.merge(loc);
            System.out.println("l : " + loc);
            System.out.println("lf: " + lokalizacjaFind);
            System.out.println("lm: " + lokalizacjaMerge);

            em.getTransaction().rollback();
            System.out.println("Zrolowano.");
        }
    }
}
