package przyklady;

import hr.model.Location;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;

public class P9_DetachMerge {

    public static void main(String[] args) {
        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr");
            EntityManager em = emf.createEntityManager()) {
            em.getTransaction().begin();

            Location lokalizacja = em.find(Location.class, 1100);
            System.out.println(lokalizacja);

            System.out.println("detach");
            em.detach(lokalizacja);

            System.out.println(lokalizacja);
            System.out.println("Zmieniam pole");
            lokalizacja.setCity("WENECJA");
            System.out.println(lokalizacja);
            // gdybym teraz zrobił commit, to ta zmiana nie zapisze się w bazie

            System.out.println("Ponowny find");
            Location lokalizacjaFind = em.find(Location.class, 1100);
            System.out.println(lokalizacjaFind);

            System.out.println("merge");
            Location lokalizacjaMerge = em.merge(lokalizacja);
            // obiekt lokalizacja nie zmienił położenia w pamięci i jest oddzielnym obiektem.
            // uwaga! dalsze zmiany na nim nie wpływają na obiekty JPA
            lokalizacja.setStreetAddress("ULICA WIELKA NOWA");

            // To wynik operacji merge jest tym obiekty należącym do puli; tutaj jest on równy lokalizacjaFind
            System.out.println("l : " + lokalizacja);
            System.out.println("lf: " + lokalizacjaFind);
            System.out.println("lm: " + lokalizacjaMerge);

            System.out.println(lokalizacja == lokalizacjaFind); // false
            System.out.println(lokalizacjaMerge == lokalizacjaFind); // true

            em.getTransaction().rollback();
            System.out.println("Zrolowano.");
        }
    }
}
