package przyklady;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import hr.model.Country;
import hr.model.Location;
import hr.model.Region;

public class P8_DodajNoweRekordy {

    public static void main(String[] args) {
        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr");
            EntityManager em = emf.createEntityManager()) {
            
            em.getTransaction().begin();
            
            // Utworzyć nowy kraj (my podajemy id) i nową lokalizację (id zostanie wygenerowane).
            
            Region region = em.find(Region.class, 1);
            Country polska = new Country();
            polska.setCountryId("PL");
            polska.setCountryName("Polska");
            polska.setRegion(region);
            System.out.println("Zaraz wykonam country.persist...");
            em.persist(polska);
            System.out.println("Wykonane");
            
            // Dla lokalizacji nie podajemy ID - ono zostanie wygenerowane z sekwencji.
            Location loc = new Location();
            loc.setCountry(polska);
            loc.setStreetAddress("Jasna");
            loc.setCity("Warszawa");
            loc.setPostalCode("00-123");
            
            System.out.println("id przed dodaniem " + loc.getId());
            em.persist(loc);
            System.out.println("id po dodaniu " + loc.getId());
            // Standard JPA nie daje gwarancji, że id zostało w tym momencie ustawione,
            // ale Hibernate tak to implementuje.

            em.getTransaction().commit();
            // Po zrobieniu commit id na pewno zostało nadane.
            System.out.println("id po commit " + loc.getId());
            System.out.println("Zapisano.");
        }
    }
}
