package przyklady;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import hr.model.Department;
import hr.model.Employee;

public class P7_AktualizujRekord2 {

    public static void main(String[] args) {
        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr");
            EntityManager em = emf.createEntityManager()) {

            em.getTransaction().begin();
            
            Employee king = em.find(Employee.class, 100);
            System.out.println(king.getId() + " " + king.getFirstName() + " " + king.getLastName());
            
            Employee kochhar = em.find(Employee.class, 101);
            System.out.println(kochhar.getId() + " " + kochhar.getFirstName() + " " + kochhar.getLastName());
            
            Department dep = em.find(Department.class, 90);
            System.out.println("departament: " + dep.getDepartmentName());
            
            System.out.println(dep == king.getDepartment());
            System.out.println(dep == kochhar.getDepartment());
            System.out.println();
            
            System.out.println("Departamenty przed zmianą: "
                    + dep.getDepartmentName() + " "
                    + king.getDepartment().getDepartmentName() + " "
                    + kochhar.getDepartment().getDepartmentName());

            king.getDepartment().setDepartmentName("Nowa nazwa");
            // king.getDepartment().setDepartmentName("Executive");
            
            System.out.println("Departamenty po zmianie: "
                    + dep.getDepartmentName() + " "
                    + king.getDepartment().getDepartmentName() + " "
                    + kochhar.getDepartment().getDepartmentName());

            System.out.println(dep == king.getDepartment());
            System.out.println(dep == kochhar.getDepartment());

            em.getTransaction().commit();
            System.out.println("Zapisane");
        }
    }

}
