package przyklady;

import hr.model.Department;
import hr.model.Employee;
import hr.model.Job;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;

import java.math.BigDecimal;
import java.util.Scanner;

public class P6_Update {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr");
            EntityManager em = emf.createEntityManager()) {
            em.getTransaction().begin();
            while(true) {
                System.out.print("\nPodaj id pracownika: ");
                int id = sc.nextInt();
                sc.nextLine();

                if(id < 0) break;
                Employee employee = em.find(Employee.class, id);
                if(employee == null) {
                    System.out.println("Nie ma pracownika o takim ID");
                    continue;
                }
                System.out.println(employee.getFirstName() + " " + employee.getLastName());

                System.out.print("Podaj nowe nazwisko: ");
                String noweNazwisko = sc.nextLine();
                employee.setLastName(noweNazwisko);

                System.out.print("Podaj zmianę pensji: ");
                BigDecimal zmiana = sc.nextBigDecimal();
                if(zmiana.compareTo(BigDecimal.ZERO) != 0) {
                    employee.setSalary(employee.getSalary().add(zmiana));
                }
                // Wywołanie flush zsynchronizowałoby zmiany dokonane w pamięci ze stanem bazy danych
                // (wykonałoby UPDATE, INSERT, DELETE)
                // ale bez zakomitowania zmian.
                // em.flush();
                System.out.println(employee.getFirstName() + " " + employee.getLastName());
            }

            // Niezależnie od użycia flush, transakcję na końcu trzeba zakomitować, aby zmiany zostały zapisane.
            // Jeśli robimy commit, to nie potrzebujemy flush
            System.out.println("\nCzy zapisać zmiany? [T/N]");
            String command = sc.nextLine();
            switch(command.toUpperCase()) {
                case "T" -> em.getTransaction().commit();
                case "N" -> em.getTransaction().rollback();
            }
        }
    }
}
