package przyklady;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import hr.model.Location;

public class P4_OdczytajWszystkich_Stream {

    public static void main(String[] args) {
        // Zapis z użyciem strumienia może dać lepszą wydajność. Zwróć uwagę na kolejność wykonywania dodatkowych selectów
        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr");
            EntityManager em = emf.createEntityManager()) {
            em.createNamedQuery("Location.findAll", Location.class)
                    .getResultStream()
                    .map(loc -> String.format(" - %s, %s %s, %s", loc.getStreetAddress(), loc.getPostalCode(), loc.getCity(),
                            loc.getCountry().getCountryName()))
                    .forEach(System.out::println);
        }
    }

}
