package przyklady;

import hr.model.Employee;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;

import java.util.List;

public class P3_OdczytajWszystkich_NamedQuery {
    public static void main(String[] args) {
        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr");
            EntityManager em = emf.createEntityManager()) {

            TypedQuery<Employee> query = em.createNamedQuery("Employee.findAll", Employee.class);
            List<Employee> employees = query.getResultList();

            System.out.println("Odczytano " + employees.size() + " rekordów.");
            for(Employee employee : employees) {
                System.out.println(employee.getFirstName() + " " + employee.getLastName()
                        + " (" + employee.getJob().getJobTitle() + "): " + employee.getSalary());
            }

        }
    }
}
