package przyklady;

import hr.model.Department;
import hr.model.Employee;
import hr.model.Job;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;

import java.util.List;
import java.util.Scanner;

public class P2_OdczytajWszystkich_JPQL {
    public static void main(String[] args) {
        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr");
            EntityManager em = emf.createEntityManager()) {

            // JPQL = Jakarta Persistence Query Language
            // Jak SQL, ale na poziomie obiektów, z pewnymi różnicami i ograniczeniami.
            TypedQuery<Employee> query = em.createQuery("SELECT e FROM Employee e", Employee.class);
            List<Employee> employees = query.getResultList();

            System.out.println("Odczytano " + employees.size() + " rekordów.");
            for(Employee employee : employees) {
                System.out.println(employee.getFirstName() + " " + employee.getLastName()
                        + " (" + employee.getJob().getJobTitle() + "): " + employee.getSalary());
            }

        }
    }
}
